//=============================================================================
 /*:
 * @target MZ
 * @plugindesc Edit Action Sequences during playtime !  - ASLE v0.1.3
 * @author ManuGamingCreations
 * @url https://manugamingcreations.itch.io
 *
 * @help
 * V 0.1.3
 * 
 * Adds a button on screen to allow you the edition of Action Sequence 
 * during playtime.
 * 
 * @param buttonText
 * @text Setup the button text
 * @type text
 * @desc Leave empty if you don't want any text
 * @default Reload Action Sequence
 * 
 * @param buttonWidth
 * @text Button Minimum Width (if no text inside for example)
 * @type number
 * @desc Button minimum width in pixels (won't work if the text inside is longer)
 * @default 150
 * 
 * @param buttonHeight
 * @text Button Minimum Height (if no text inside for example)
 * @type number
 * @desc Button minimum height in pixels (won't work if the text inside is taking more space)
 * @default 20
 * 
 * @param buttonPosition
 * @text Where should be the button on game screen?
 * @type select
 * @option Top Left
 * @option Top Right
 * @option Bottom Left
 * @option Bottom Right
 * @default Top Left
 * 
 * @param offset
 * @text Offset
 * 
 * @param offsetX
 * @text X
 * @type text
 * @default 0
 * @desc Put a negative or positive value here. Examples: -30 or 25.
 * @parent offset
 * 
 * @param offsetY
 * @text Y
 * @type text
 * @default 0
 * @desc Put a negative or positive value here. Examples: -30 or 25.
 * @parent offset
 * 
*/

document.extraDiv = document.createElement('div');
document.ActionSequenceReloaderButton = document.createElement('button');
document.extraDiv.appendChild(document.ActionSequenceReloaderButton);
document.body.appendChild(document.extraDiv);
document.body.style.overflow = 'hidden';

let MGC_pluginParams = PluginManager.parameters('ActionSequenceLiveEditor');
let reloadButton = document.ActionSequenceReloaderButton;

reloadButton.style.position = 'absolute';
reloadButton.style.zIndex = 999;
reloadButton.style.minWidth = MGC_pluginParams['buttonWidth'] + 'px';
reloadButton.style.minHeight = MGC_pluginParams['buttonHeight'] + 'px';
reloadButton.innerText = MGC_pluginParams['buttonText'];





let positionParam = MGC_pluginParams['buttonPosition'];
let offsetXparam = Number(MGC_pluginParams['offsetX']);
let offsetYparam = Number(MGC_pluginParams['offsetY']);

let buttonLeftPos = 0;
let buttonTopPos = 0;

let buttonWidth = document.ActionSequenceReloaderButton.clientWidth;
let buttonHeight = document.ActionSequenceReloaderButton.clientHeight * 2;


// Initial position
if(positionParam === "Top Left") {
    buttonLeftPos = 0;
    buttonTopPos = 0;
} else if(positionParam === "Top Right") {
    buttonLeftPos = window.innerWidth - buttonWidth;
    buttonTopPos = 0;
} else if(positionParam === "Bottom Left") {
    buttonLeftPos = 0;
    buttonTopPos = window.innerHeight - buttonHeight;
} else if(positionParam === "Bottom Right") {
    buttonLeftPos = window.innerWidth - buttonWidth;
    buttonTopPos = window.innerHeight - buttonHeight;
}

console.log(buttonLeftPos);
console.log(buttonTopPos);

// Apply Offset
buttonLeftPos += offsetXparam;
buttonTopPos += offsetYparam;

// Setup button position on screen
document.ActionSequenceReloaderButton.style.left = buttonLeftPos + 'px' ;
document.ActionSequenceReloaderButton.style.top = buttonTopPos + 'px' ;
document.extraDiv.style.left = 0 + 'px' ;
document.extraDiv.style.top = 0 + 'px' ;
document.ActionSequenceReloaderButton.onclick = function(e){
    DataManager.loadDataFile('$dataCommonEvents', 'CommonEvents.json');
}